Option Explicit

Const BIF_RETURNONLYFSDIRS = 1

QuickInstall

' This function is used by the HTA file to open documents and run EXE files.
Sub ClickExecute(strCommand, strPath)
    Dim oShell, CurrentDirectory

    Set oShell = CreateObject("WScript.Shell")
    'MsgBox strPath
    CurrentDirectory = oShell.CurrentDirectory
    oShell.CurrentDirectory = strPath
    'MsgBox oShell.CurrentDirectory
    'MsgBox strCommand
    oShell.Run strCommand

    oShell.CurrentDirectory = CurrentDirectory
End Sub

' Attempts to systematically create the folder specified.
Sub CreateFolder(FileSystemObject, FolderSpec)
    Dim ParentFolder

    ' Get the parent folder for the folder specified.
    ParentFolder = FileSystemObject.GetParentFolderName(FolderSpec)

    ' If the parent folder does not exist, attempt to systematically create it.
    If Not FileSystemObject.FolderExists(ParentFolder) Then CreateFolder FileSystemObject, ParentFolder

    ' If the current folder does not exist, create it.
    If Not FileSystemObject.FolderExists(FolderSpec) Then FileSystemObject.CreateFolder FolderSpec
End Sub

' Performs a "quick" install of PSI-Utility by copying the source folder to the specified destination.
Sub QuickInstall
    Dim FileSystemObject, CurrentFolder, WshShell, LinkFile, DesktopFolder, ShellLink, AppShell, DestinationFolder, Msg

    ' Get the shell and file system object instances.
    Set AppShell = CreateObject("Shell.Application")
    Set WshShell = CreateObject("WScript.Shell")
    Set FileSystemObject = CreateObject("Scripting.FileSystemObject")

    ' Get the current folder for the CD and the desktop folder.
    CurrentFolder = WshShell.CurrentDirectory
    DesktopFolder = WshShell.SpecialFolders("Desktop")

    ' Determine whether of not the operator wishes to install to the default path.
    Select Case MsgBox("Do you wish to install PSI Utility to the C:\WPSI\psi-Utility folder?", vbQuestion Or vbYesNoCancel, "Quick Install")
    Case vbCancel
        ' If cancelling, exit.
        Exit Sub
    Case vbYes
        ' If yes, set the default path.
        DestinationFolder = "C:\WPSI\psi-Utility"
    Case vbNo
        ' Get the destination file for the PSI Utility software.
        Set DestinationFolder = AppShell.BrowseForFolder(0, "Select Folder for PSI Utility application", BIF_RETURNONLYFSDIRS)
        If DestinationFolder Is Nothing Then Exit Sub
        If IsObject(DestinationFolder) Then DestinationFolder = DestinationFolder.Self.Path
    End Select

    ' Does the destination folder already exist on the target system?
    If FileSystemObject.FolderExists(DestinationFolder) Then
        ' If so, provide the option to archive it.
        Msg = "Archive the existing copy of PSI Utility found on this system." & vbCrLf & _
              "Select No to overwrite existing copy."

        Select Case MsgBox(Msg, vbQuestion Or vbYesNoCancel, "Quick Install")
        Case vbCancel
            ' If cancelling, exit.
            Exit Sub
        Case vbYes
            ' Copy the original destination folder to a temporary location before deleting.
            FileSystemObject.MoveFolder DestinationFolder, FileSystemObject.BuildPath(FileSystemObject.GetParentFolderName(DestinationFolder), FileSystemObject.GetTempName)
            FileSystemObject.DeleteFolder DestinationFolder, True
        Case vbNo
            ' Delete the destination folder for the existing install.
            FileSystemObject.DeleteFolder DestinationFolder, True
        End Select
    End If

    ' Copy the PSI Utility folder to the C drive.
    FileSystemObject.CopyFolder FileSystemObject.BuildPath(CurrentFolder, "psi-Utility"), DestinationFolder, True

    ' Get the link file for the PSI Utility application.
    LinkFile = FileSystemObject.BuildPath(DesktopFolder, "PSI Utility.lnk")
    If FileSystemObject.FileExists(LinkFile) Then FileSystemObject.DeleteFile LinkFile

    ' Create and initialize the link on the desktop.
    Set ShellLink = WshShell.CreateShortcut(LinkFile)
    ShellLink.TargetPath = FileSystemObject.BuildPath(DestinationFolder, "PSI-Utility.exe")
    ShellLink.WorkingDirectory = DestinationFolder
    ShellLink.IconLocation = FileSystemObject.BuildPath(DestinationFolder, "PSI-Utility.exe")
    ShellLink.Save

    ' Get the link file for the PSI Utility Factory Mode application.
    LinkFile = FileSystemObject.BuildPath(DesktopFolder, "PSI Utility Factory.lnk")
    If FileSystemObject.FileExists(LinkFile) Then FileSystemObject.DeleteFile LinkFile

    ' Create and initialize the link on the desktop.
    Set ShellLink = WshShell.CreateShortcut(LinkFile)
    ShellLink.TargetPath = FileSystemObject.BuildPath(DestinationFolder, "PSI-Utility.exe")
    ShellLink.WorkingDirectory = DestinationFolder
    ShellLink.IconLocation = FileSystemObject.BuildPath(DestinationFolder, "PSI-Utility.exe")
    ShellLink.Arguments = "-factory"
    ShellLink.Save

    ' One last check, see if this is DTC Verification.
    'If MsgBox("Is this DTC Verification?", vbQuestion Or vbYesNo, "Quick Install") = vbYes Then
    '    FileSystemObject.DeleteFile FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.txt")
    '    FileSystemObject.MoveFile FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.dtc"), FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.txt")
    'Else
    '    FileSystemObject.DeleteFile FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.txt")
    '    FileSystemObject.MoveFile FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.psi"), FileSystemObject.BuildPath(DestinationFolder, "InitiumSetup.txt")
    'End If

    ' Indicate to the operator the installation was successful.
    MsgBox "Quick Install Successful"
End Sub
